/**
 *
 *
 *  iRoom framework V2.0 <https://iroom.re>
 *
 *  By KRATZ Geoffrey AKA Jul6art AKA VanIllaSkype
 *  for VsWeb <https://vsweb.be>
 *
 *  https://vsweb.be
 *  admin@vsweb.be
 *
 *  Special thanks to Brynnlow
 *  for his contribution
 *
 *  It is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License, either version 2
 *  of the License, or any later version.
 *
 *  For the full copyright and license information, please read the
 *  LICENSE.txt file that was distributed with this source code.
 *
 *  The flex one, in a flex world
 *
 */



module Iroom {
    declare let $: any;

    /**
     * Class Smooth
     *
     * smooth scrolling
     */
    export class Smooth {
        private options                     : SmoothOptions;
        private delay                       : number;
        private links                       : any;


        /**
         * Loader constructor
         */
        constructor(options : SmoothOptions = null) {
            this.options                    = options;
            this.links                      = document.querySelectorAll("a");
            this.init();
        }


        /**
         * init events
         */
        init() {
            this.scrollEvent();
        }


        /**
         * Event when users navigate to an anchor
         */
        scrollEvent() {
            for(var i in this.links) {
                if(this.links[i]) {
                    let link : HTMLElement  = this.links[i];
                    if(!link.classList || !link.classList.contains("close,next,prev")) {
                        if(this.getAttr(link, "href") && this.getAttr(link, "href")[0] === "#" && this.getAttr(link, "href")[1] !== "!" && this.getAttr(link, "href")[1] !== "0" && this.getAttr(link, "href")[1] !== null) {
                            link.addEventListener('click', (e) => {
                                e.preventDefault();
                                this.setDelay(link);
                                let url : string = this.getAttr(link, "href").substr(1);
                                let element     = document.getElementById(url);
                                if(element !== null) {
                                    this.scrollTo(element.offsetTop, this.delay);
                                }
                            });
                        }
                    }
                }
            }
        }


        setDelay(link) {
            this.delay                      = 1000;
            if (this.options != null && this.options.duration > 0) {
                this.delay                  = this.options.duration;
            }
            if (link != null && parseInt(link.getAttribute("data-duration")) > 0) {
                this.delay                  = parseInt(link.getAttribute("data-duration"));
            }
        }


        scrollTo(to, duration) {
            let start                       = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0,
                change                      = to - start,
                increment                   = 20;

            let animateScroll = (elapsedTime) => {
                elapsedTime += increment;
                let position                = easeInOut(elapsedTime, start, change, duration);
                document.documentElement.scrollTop = position;
                document.body.scrollTop     = position;
                if (elapsedTime < duration) {
                    setTimeout(() => {
                        animateScroll(elapsedTime);
                    }, increment);
                }
            };

            let easeInOut = (currentTime, start, change, duration) => {
                currentTime /= duration / 2;
                if (currentTime < 1) {
                    return change / 2 * currentTime * currentTime + start;
                }
                currentTime -= 1;
                return -change / 2 * (currentTime * (currentTime - 2) - 1) + start;
            }

            animateScroll(0);
        }


        /**
         * Function to hack the IE BUG
         *
         * Undefiend function eobject.getAttribute()
         *
         * @param ele
         * @param attr
         * @returns {(function(string=): string)|string|null}
         */
        getAttr(ele, attr) {
            let result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if( !result ) {
                var attrs = ele.attributes;
                if(attrs != null) {
                    var length = attrs.length;
                    for(var i = 0; i < length; i++) {
                        if(attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        }
    }

    /**
     * interface Smooth Options
     */
    interface SmoothOptions {
        duration : number;
    }
}