/**
 *
 *
 *  iRoom framework V2.0 <https://iroom.re>
 *
 *  By KRATZ Geoffrey AKA Jul6art AKA VanIllaSkype
 *  for VsWeb <https://vsweb.be>
 *
 *  https://vsweb.be
 *  admin@vsweb.be
 *
 *  Special thanks to Brynnlow
 *  for his contribution
 *
 *  It is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License, either version 2
 *  of the License, or any later version.
 *
 *  For the full copyright and license information, please read the
 *  LICENSE.txt file that was distributed with this source code.
 *
 *  The flex one, in a flex world
 *
 */



module Iroom {
    declare let $: any;

    /**
     * Class Loader
     *
     * page navigation loader
     */
    export class Loader {
        private options                     : LoaderOptions;
        private body                        : HTMLElement;
        private delay                       : number;
        private loader                      : any;
        private links                       : any;


        /**
         * Loader constructor
         */
        constructor(options : LoaderOptions = null) {
            this.body                       = document.body;
            this.loader                     = document.getElementById("loader");
            this.options                    = options;
            this.links                      = document.querySelectorAll("body.animated a");
            this.init();
        }


        /**
         * init events
         */
        init() {
            this.setDelay();
            this.pageInEvent(this.body);
            this.pageOutEvent(this.body);
        }


        /**
         * Event when page is loading
         */
        pageInEvent(body: HTMLElement) {
            setTimeout(() => {
                body.classList.remove("animated");
            }, this.delay);
        }


        /**
         * Event when user pushes on a link
         */
        pageOutEvent(body: HTMLElement) {
            for(var i in this.links) {
                if(this.links[i]) {
                    let link : HTMLElement  = this.links[i];
                    if(!link.classList || !link.classList.contains("close,next,prev")) {
                        if(this.getAttr(link, "href") && this.getAttr(link, "href")[0] !== "#" && this.getAttr(link, "href") !== "" && this.getAttr(link, "target") != "_blank") {
                            link.addEventListener('click', (e) => {
                                e.preventDefault();
                                this.body.classList.add("animated");
                                let url : string = this.getAttr(link, "href");
                                setTimeout(() => {
                                    location.href = url;
                                }, this.delay);
                                setTimeout(() => {
                                    this.body.classList.remove("animated");
                                }, this.delay * 1.5);
                            });
                        }
                    }
                }
            }
        }


        setDelay() {
            this.delay                      = 1000;
            if (this.options != null && this.options.duration > 0) {
                this.delay                  = this.options.duration;
            }
            if (this.loader != null && parseInt(this.loader.getAttribute("data-duration")) > 0) {
                this.delay                  = parseInt(this.loader.getAttribute("data-duration"));
            }
        }


        /**
         * Function to hack the IE BUG
         *
         * Undefiend function eobject.getAttribute()
         *
         * @param ele
         * @param attr
         * @returns {(function(string=): string)|string|null}
         */
        getAttr(ele, attr) {
            let result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if( !result ) {
                var attrs = ele.attributes;
                if(attrs != null) {
                    var length = attrs.length;
                    for(var i = 0; i < length; i++) {
                        if(attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        }
    }

    /**
     * interface Loader Options
     */
    interface LoaderOptions {
        duration : number;
    }
}