/**
 *
 *
 *  iRoom framework V2.0 <https://iroom.re>
 *
 *  By KRATZ Geoffrey AKA Jul6art AKA VanIllaSkype
 *  for VsWeb <https://vsweb.be>
 *
 *  https://vsweb.be
 *  admin@vsweb.be
 *
 *  Special thanks to Brynnlow
 *  for his contribution
 *
 *  It is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License, either version 2
 *  of the License, or any later version.
 *
 *  For the full copyright and license information, please read the
 *  LICENSE.txt file that was distributed with this source code.
 *
 *  The flex one, in a flex world
 *
 */



module Iroom {
    declare let $: any;

    /**
     * Class Smooth
     *
     * smooth scrolling
     */
    export class Components {
        private body                        : HTMLElement;
        private alerts                      : any;
        private links                       : any;
        private asideLinks                  : any;
        private inputContainers             : any;
        private inputPasswordContainers     : any;
        private filters                     : any;
        private dropdowns                   : any;
        private mobileMenu                  : any;


        /**
         * Loader constructor
         */
        constructor() {
            this.body                       = document.body;
            this.alerts                     = document.querySelectorAll(".alert.dismissable");
            this.links                      = document.querySelectorAll(".disabled, [readonly]");
            this.asideLinks                 = document.querySelectorAll(".aside-nav a");
            this.inputContainers            = document.querySelectorAll(".input-group:not(.input-password), .input-group-left:not(.input-password), .input-group-double:not(.input-password)");
            this.inputPasswordContainers    = document.querySelectorAll(".input-password");
            this.filters                    = document.querySelectorAll(".filters .filter-button");
            this.dropdowns                  = document.querySelectorAll(".dropdown");
            this.mobileMenu                 = document.querySelectorAll("div.mobile-menu");
            this.init();
        }


        /**
         * init events
         */
        init() {
            this.disabledEvent();
            this.asideNavEvent();
            this.closeEvent();
            this.inputsEvent();
            this.passwordInputEvent();
            this.filtersEvent();
            this.dropdownEvent();
            this.menuEvent();
        }


        /**
         * Event when users pushes a sidebar navigation button
         */
        asideNavEvent() {
            window.addEventListener('scroll', (e) => {
                this.resetActiveClass(this.asideLinks);

                for(var i in this.asideLinks) {
                    if(this.asideLinks[i]) {
                        let link : HTMLElement  = this.asideLinks[i];
                        if(this.getAttr(link, "href")) {
                            let anchor      = link.getAttribute("href").substr(1);
                            let item        = document.getElementById(anchor);
                            if(item != null) {
                                let scrollTop   = document.documentElement.scrollTop || document.body.scrollTop;
                                if(scrollTop >= item.offsetTop) {
                                    this.resetActiveClass(this.asideLinks);
                                    link.classList.add("active");
                                }
                            }
                        }
                    }
                }
            });
        }


        resetActiveClass(links) {
            for(var i in links) {
                if(links[i]) {
                    let link : HTMLElement  = links[i];
                    if(typeof link == "object" && link.classList) {
                        link.classList.remove("active");
                    }
                }
            }
        }


        /**
         * Event when users pushes a disabled button
         */
        disabledEvent() {
            for(var i in this.links) {
                if(this.links[i]) {
                    let link : HTMLElement = this.links[i];
                    if(typeof link == "object") {
                        link.addEventListener('click', (e) => {
                            e.preventDefault();
                        });
                    }
                }
            }
        }


        /**
         * Event when users close an alert
         */
        closeEvent() {
            for(var i in this.alerts) {
                if(this.alerts[i]) {
                    let alert : HTMLElement = this.alerts[i];
                    if(typeof alert == "object") {
                        alert.addEventListener('click', (e) => {
                            e.preventDefault();
                            if(alert.classList) {
                                alert.classList.add("closed");
                            }
                        });
                    }
                }
            }
        }


        /**
         * function that focus an input
         *
         * when user click an input addon span
         */
        inputsEvent() {
            for(var i in this.inputContainers) {
                if(this.inputContainers[i]) {
                    let container : HTMLElement = this.inputContainers[i];
                    if(typeof container == "object") {
                        container.addEventListener("click", () => {
                            let input           = <HTMLElement>container.querySelectorAll("input, select, textarea")[0];
                            if(typeof input == "object") {
                                input.focus();
                            }
                        });
                    }

                }
            }
        }


        /**
         * function that focus an input
         * when user click an input addon span
         *
         * this function permit also the toggle for password field
         */
        passwordInputEvent() {
            for(var i in this.inputPasswordContainers) {
                if(this.inputPasswordContainers[i]) {
                    let container : HTMLElement = this.inputPasswordContainers[i];
                    if(typeof container == "object") {
                        let spans           = container.querySelectorAll("span");
                        let input           = <HTMLElement>container.querySelectorAll("input, select, textarea")[0];
                        for(var ii in spans) {
                            if(spans[ii]) {
                                let span = <HTMLElement>spans[ii];
                                if(typeof span == "object" && typeof input == "object") {
                                    span.addEventListener("click", () => {
                                        if(this.getAttr(input, "type")) {
                                            if(this.getAttr(input, "type") == "password") {
                                                input.setAttribute("type", "text");
                                                span.innerHTML = '<i class="fa fa-eye-slash"></i>';
                                            } else {
                                                input.setAttribute("type", "password");
                                                span.innerHTML = '<i class="fa fa-eye"></i>';
                                            }
                                        }
                                        input.focus();
                                    });
                                }
                            }
                        }
                    }

                }
            }
        }


        /**
         * function that enable filtering by class
         * when user click a button with filter-button class
         *
         * this function permit also the toggle for password field
         */
        filtersEvent() {
            for(var i in this.filters) {
                if(this.filters[i]) {
                    let button : HTMLElement = this.filters[i];
                    if(typeof button == "object") {
                        button.addEventListener("click", (e) => {
                            e.preventDefault();
                            button.classList.add("active");
                            let targets = document.querySelectorAll('.filters .filter-display.filter-disabled');
                            for(var ii in targets) {
                                if(targets[ii]) {
                                    let target : Element = targets[ii];
                                    if(typeof target == "object") {
                                        target.classList.remove("filter-disabled");
                                    }
                                }
                            }

                            let value = this.getAttr(button, "data-filter");

                            if(value !== "all") {
                                let targetsFiltered = document.querySelectorAll('.filters .filter-display:not([data-filter="' + value + '"])');
                                for(var iii in targetsFiltered) {
                                    if(targetsFiltered[iii]) {
                                        let targetFiltered : Element = targetsFiltered[iii];
                                        if(typeof targetFiltered == "object") {
                                            targetFiltered.classList.add("filter-disabled");
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
            }
        }


        /**
         * function that toggle state of dropdowns
         *
         * when user click on the button
         */
        dropdownEvent() {
            for(var i in this.dropdowns) {
                if(this.dropdowns[i]) {
                    let dropdown : HTMLElement = this.dropdowns[i];
                    if(typeof dropdown == "object") {
                        let target = dropdown.querySelector("[data-expanded]");
                        if(target) {
                            target.addEventListener("click", () => {
                                this.resetDropdown(dropdown);
                                this.classToggle(dropdown, "open");
                            });
                        }
                    }
                }
            }
        }


        resetDropdown(active) {
            for(var ii in this.dropdowns) {
                if(this.dropdowns[ii]) {
                    let elem : HTMLElement = this.dropdowns[ii];
                    if(typeof elem == "object") {
                        if(elem !== active) {
                            elem.classList.remove("open");
                        }
                    }
                }
            }
        }


        /**
         * function that toggle state of mobile menu
         *
         * when user click on the hamburger icon
         */
        menuEvent() {
            for(var i in this.mobileMenu) {
                if(this.mobileMenu[i]) {
                    let hamburger : HTMLElement = this.mobileMenu[i];
                    if(typeof hamburger == "object") {
                        hamburger.addEventListener("click", () => {
                            let targetSelector = this.getAttr(hamburger, "data-menu");
                            if(targetSelector) {
                                let target = document.querySelector('#' + targetSelector);
                                if(target) {
                                    this.classToggle(hamburger, "open");
                                    this.classToggle(this.body, "mobile-menu-enabled");
                                    this.classToggle(target, "mobile-menu-enabled");
                                }
                            }
                        });
                    }

                }
            }
        }


        /**
         * Function to hack the IE BUG
         *
         * Undefined function eobject.getAttribute()
         *
         * @param ele
         * @param attr
         * @returns {(function(string=): string)|string|null}
         */
        getAttr(ele, attr) {
            let result = (ele.getAttribute && ele.getAttribute(attr)) || null;
            if( !result ) {
                var attrs = ele.attributes;
                if(attrs != null) {
                    var length = attrs.length;
                    for(var i = 0; i < length; i++) {
                        if(attrs[i].nodeName === attr) {
                            result = attrs[i].nodeValue;
                        }
                    }
                }
            }
            return result;
        }


        /**
         * Function that add toggleClass method
         *
         * @param ele
         * @param string
         */
        classToggle(ele, string : string) {
            if(ele.classList.contains(string)) {
                ele.classList.remove(string);
            } else {
                ele.classList.add(string);
            }
        }
    }
}

new Iroom.Components();